<?php

namespace App\Http\Controllers;

use App\Models\Bot;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $totalBots = Bot::count();
        $runningBots = Bot::where('status', 'running')->count();
        $stoppedBots = Bot::where('status', 'stopped')->count();
        $recentBots = Bot::latest()->limit(5)->get();

        return view('dashboard', compact('totalBots', 'runningBots', 'stoppedBots', 'recentBots'));
    }
}