<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SettingsController extends Controller
{
    public function index()
    {
        return view('settings');
    }

    public function update(Request $request)
    {
        $request->validate([
            'site_name' => 'required|string|max:255'
        ]);

        $envFile = base_path('.env');
        $env = File::get($envFile);

        // Update or add SITE_NAME
        if (preg_match('/^SITE_NAME=.*/m', $env)) {
            $env = preg_replace('/^SITE_NAME=.*/m', 'SITE_NAME="' . $request->site_name . '"', $env);
        } else {
            $env .= "\nSITE_NAME=\"" . $request->site_name . "\"\n";
        }

        File::put($envFile, $env);

        return redirect()->route('settings')->with('success', 'Settings berhasil diupdate!');
    }
}