import './bootstrap';

document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuBtn = document.getElementById('mobile-menu-btn');
    const mobileSidebarOverlay = document.getElementById('mobile-sidebar-overlay');
    const closeMobileSidebar = document.getElementById('close-mobile-sidebar');
    
    if (mobileMenuBtn && mobileSidebarOverlay) {
        const openSidebar = () => {
            mobileSidebarOverlay.classList.add('show');
            document.body.style.overflow = 'hidden';
        };
        
        const closeSidebar = () => {
            mobileSidebarOverlay.classList.remove('show');
            document.body.style.overflow = '';
        };
        
        mobileMenuBtn.addEventListener('click', openSidebar);
        closeMobileSidebar?.addEventListener('click', closeSidebar);
        
        mobileSidebarOverlay.addEventListener('click', (e) => {
            if (e.target === mobileSidebarOverlay) {
                closeSidebar();
            }
        });
        
        document.addEventListener('keydown', (e) => {
            if (e.key === 'Escape' && mobileSidebarOverlay.classList.contains('show')) {
                closeSidebar();
            }
        });
    }
});