@extends('layouts.app')

@section('title', 'Create Bot - PyRunner 2.0.1')
@section('page-title', 'Create Bot')
@section('page-subtitle', 'Tambah bot baru ke sistem')

@section('content')
    <div class="max-w-4xl">
        <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden">
            <div class="px-6 py-4 border-b border-zinc-800">
                <h3 class="text-lg font-bold text-zinc-100">Form Tambah Bot</h3>
            </div>

            <div class="p-6">
                <!-- Info Alert -->
                <div class="bg-blue-500/10 border border-blue-500/20 p-4 mb-6 rounded-lg">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-blue-400 mr-2" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd"
                                d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                clip-rule="evenodd" />
                        </svg>
                        <p class="text-blue-300 text-sm">
                            Detected Python: <strong class="text-blue-400">{{ getPythonVersion() }}</strong>
                        </p>
                    </div>
                </div>

                <form action="{{ route('bots.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf

                    <!-- Nama Bot -->
                    <div class="mb-6">
                        <label for="name" class="block text-sm font-medium text-zinc-300 mb-2">
                            Nama Bot <span class="text-red-500">*</span>
                        </label>
                        <input type="text" id="name" name="name" value="{{ old('name') }}"
                            class="w-full px-4 py-2.5 bg-zinc-800 border border-zinc-700 rounded-lg text-zinc-100 placeholder-zinc-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('name') border-red-500 @enderror"
                            placeholder="Contoh: Bot Trading Crypto" required>
                        @error('name')
                            <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Command Python -->
                    <div class="mb-6">
                        <label for="command" class="block text-sm font-medium text-zinc-300 mb-2">
                            Command Python <span class="text-red-500">*</span>
                        </label>
                        <input type="text" id="command" name="command" value="{{ old('command', 'python3 main.py') }}"
                            class="w-full px-4 py-2.5 bg-zinc-800 border border-zinc-700 rounded-lg text-zinc-100 placeholder-zinc-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('command') border-red-500 @enderror"
                            placeholder="python3 main.py" required>
                        <p class="text-xs text-zinc-500 mt-1 flex items-center">
                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                    clip-rule="evenodd" />
                            </svg>
                            VPS Python Version: {{ getPythonVersion() }}
                        </p>
                        @error('command')
                            <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- File Bot -->
                    <div class="mb-6">
                        <label for="bot_file" class="block text-sm font-medium text-zinc-300 mb-2">
                            File Bot (ZIP) <span class="text-red-500">*</span>
                        </label>
                        <div class="relative">
                            <input type="file" id="bot_file" name="bot_file" accept=".zip"
                                class="w-full px-4 py-2.5 bg-zinc-800 border border-zinc-700 rounded-lg text-zinc-400 file:mr-4 file:py-2 file:px-4 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-zinc-700 file:text-zinc-300 hover:file:bg-zinc-600 focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('bot_file') border-red-500 @enderror"
                                required>
                        </div>
                        <p class="text-xs text-zinc-500 mt-1 flex items-center">
                            <svg class="w-3 h-3 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                    clip-rule="evenodd" />
                            </svg>
                            Upload file ZIP, akan otomatis diekstrak. Maksimal 50MB
                        </p>
                        @error('bot_file')
                            <p class="text-red-400 text-xs mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <!-- Buttons -->
                    <div class="flex space-x-3">
                        <button type="submit"
                            class="flex-1 bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-6 rounded-lg transition-all duration-200 flex items-center justify-center space-x-2">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                <path
                                    d="M7.707 10.293a1 1 0 10-1.414 1.414l3 3a1 1 0 001.414 0l3-3a1 1 0 00-1.414-1.414L11 11.586V6h5a2 2 0 012 2v7a2 2 0 01-2 2H4a2 2 0 01-2-2V8a2 2 0 012-2h5v5.586l-1.293-1.293zM9 4a1 1 0 012 0v2H9V4z" />
                            </svg>
                            <span>Simpan Bot</span>
                        </button>
                        <a href="{{ route('bots.index') }}"
                            class="flex-1 bg-zinc-700 hover:bg-zinc-600 text-zinc-200 font-semibold py-3 px-6 rounded-lg transition-all duration-200 flex items-center justify-center space-x-2">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd"
                                    d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z"
                                    clip-rule="evenodd" />
                            </svg>
                            <span>Kembali</span>
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection