@extends('layouts.app')

@section('title', 'File Manager - PyRunner 2.0.1')
@section('page-title', 'File Manager')
@section('page-subtitle', 'Kelola file bot yang telah diupload')

@section('content')
    <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-zinc-800">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-bold text-zinc-100">Bot Files</h3>
                <span class="text-sm text-zinc-500">Total: <span
                        class="text-zinc-300 font-medium">{{ count($botFolders) }}</span> folder(s)</span>
            </div>
        </div>

        <div class="p-6">
            @if(count($botFolders) > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($botFolders as $folder)
                        <div
                            class="bg-zinc-800 border border-zinc-700 rounded-lg p-5 hover:border-zinc-600 transition-all duration-200 card-hover">
                            <div class="flex items-start justify-between mb-4">
                                <div class="flex items-center space-x-3">
                                    <div
                                        class="w-10 h-10 rounded-lg bg-yellow-500/10 flex items-center justify-center flex-shrink-0">
                                        <svg class="w-6 h-6 text-yellow-500" fill="currentColor" viewBox="0 0 20 20">
                                            <path d="M2 6a2 2 0 012-2h5l2 2h5a2 2 0 012 2v6a2 2 0 01-2 2H4a2 2 0 01-2-2V6z" />
                                        </svg>
                                    </div>
                                    <div>
                                        <h4 class="font-medium text-zinc-200 truncate max-w-[150px]">{{ $folder['name'] }}</h4>
                                        <p class="text-xs text-zinc-500">{{ $folder['bot_name'] ?? 'Unknown' }}</p>
                                    </div>
                                </div>
                            </div>

                            <div class="space-y-2 text-sm mb-4">
                                <div class="flex justify-between items-center">
                                    <span class="text-zinc-500">Files:</span>
                                    <span class="font-medium text-zinc-300">{{ $folder['file_count'] }}</span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-zinc-500">Size:</span>
                                    <span class="font-medium text-zinc-300">{{ $folder['size'] }}</span>
                                </div>
                                <div class="flex justify-between items-center">
                                    <span class="text-zinc-500">Modified:</span>
                                    <span class="font-medium text-zinc-300">{{ $folder['modified'] }}</span>
                                </div>
                            </div>

                            <div class="pt-4 border-t border-zinc-700 flex space-x-2">
                                <a href="{{ route('filemanager.browse', $folder['name']) }}"
                                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white text-center py-2 px-3 rounded-lg text-xs font-medium transition-all duration-200">
                                    Browse
                                </a>
                                <form action="{{ route('filemanager.delete', $folder['name']) }}" method="POST" class="flex-1"
                                    onsubmit="return confirm('Yakin ingin menghapus folder ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit"
                                        class="w-full bg-red-600 hover:bg-red-700 text-white py-2 px-3 rounded-lg text-xs font-medium transition-all duration-200">
                                        Delete
                                    </button>
                                </form>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-16">
                    <svg class="w-16 h-16 text-zinc-700 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2h-6l-2-2H5a2 2 0 00-2 2z" />
                    </svg>
                    <p class="text-zinc-400 text-lg font-medium mb-1">Belum ada file</p>
                    <p class="text-zinc-600 text-sm">Upload bot untuk melihat file</p>
                </div>
            @endif
        </div>
    </div>
@endsection