@extends('layouts.app')

@section('title', 'Settings - PyRunner 2.0.1')
@section('page-title', 'Settings')
@section('page-subtitle', 'Kelola pengaturan aplikasi')

@section('content')
    <div class="max-w-4xl">
        @if(session('success'))
            <div class="bg-green-500/10 border border-green-500/20 text-green-400 p-4 mb-6 rounded-lg alert-enter">
                <div class="flex items-center">
                    <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                            clip-rule="evenodd" />
                    </svg>
                    <p class="font-medium">{{ session('success') }}</p>
                </div>
            </div>
        @endif

        <!-- Site Settings -->
        <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden mb-6">
            <div class="px-6 py-4 border-b border-zinc-800">
                <h3 class="text-lg font-bold text-zinc-100">Site Settings</h3>
            </div>
            <div class="p-6">
                <form action="{{ route('settings.update') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="mb-6">
                        <label for="site_name" class="block text-sm font-medium text-zinc-300 mb-2">
                            Nama Website
                        </label>
                        <input type="text" id="site_name" name="site_name" value="{{ getSiteName() }}"
                            class="w-full px-4 py-2.5 bg-zinc-800 border border-zinc-700 rounded-lg text-zinc-100 placeholder-zinc-500 focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                            required>
                        <p class="text-xs text-zinc-500 mt-1">Nama ini akan muncul di sidebar dan halaman login</p>
                    </div>

                    <div class="flex items-center justify-between">
                        <button type="submit"
                            class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2.5 px-6 rounded-lg transition-all duration-200">
                            Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- System Info -->
        <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden">
            <div class="px-6 py-4 border-b border-zinc-800">
                <h3 class="text-lg font-bold text-zinc-100">System Information</h3>
            </div>
            <div class="p-6">
                <dl class="grid grid-cols-1 gap-4">
                    <div class="flex justify-between items-center py-3 border-b border-zinc-800">
                        <dt class="text-sm font-medium text-zinc-400">Python Version</dt>
                        <dd class="text-sm font-bold text-zinc-200">{{ getPythonVersion() }}</dd>
                    </div>
                    <div class="flex justify-between items-center py-3 border-b border-zinc-800">
                        <dt class="text-sm font-medium text-zinc-400">PHP Version</dt>
                        <dd class="text-sm font-bold text-zinc-200">{{ phpversion() }}</dd>
                    </div>
                    <div class="flex justify-between items-center py-3 border-b border-zinc-800">
                        <dt class="text-sm font-medium text-zinc-400">Laravel Version</dt>
                        <dd class="text-sm font-bold text-zinc-200">{{ app()->version() }}</dd>
                    </div>
                    <div class="flex justify-between items-center py-3 border-b border-zinc-800">
                        <dt class="text-sm font-medium text-zinc-400">Server</dt>
                        <dd class="text-sm font-bold text-zinc-200">{{ gethostname() }}</dd>
                    </div>
                    <div class="flex justify-between items-center py-3 border-b border-zinc-800">
                        <dt class="text-sm font-medium text-zinc-400">Operating System</dt>
                        <dd class="text-sm font-bold text-zinc-200">{{ PHP_OS }}</dd>
                    </div>
                    <div class="flex justify-between items-center py-3">
                        <dt class="text-sm font-medium text-zinc-400">Storage Path</dt>
                        <dd class="text-sm font-bold text-zinc-200 truncate max-w-md">{{ storage_path('app/bots') }}</dd>
                    </div>
                </dl>
            </div>
        </div>
    </div>
@endsection