<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BotController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\FileManagerController;
use Illuminate\Support\Facades\Route;

// Auth Routes
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Protected Routes
Route::middleware('auth')->group(function () {
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');

    // Bots
    Route::prefix('bots')->name('bots.')->group(function () {
        Route::get('/', [BotController::class, 'index'])->name('index');
        Route::get('/create', [BotController::class, 'create'])->name('create');
        Route::post('/', [BotController::class, 'store'])->name('store');
        Route::post('/{bot}/start', [BotController::class, 'start'])->name('start');
        Route::post('/{bot}/stop', [BotController::class, 'stop'])->name('stop');
        Route::post('/{bot}/restart', [BotController::class, 'restart'])->name('restart');
        Route::delete('/{bot}', [BotController::class, 'destroy'])->name('destroy');
        Route::get('/status', [BotController::class, 'status'])->name('status');
        Route::get('/{bot}/logs', [BotController::class, 'logs'])->name('logs');
        Route::post('/{bot}/logs/clear', [BotController::class, 'clearLogs'])->name('logs.clear');
    });

    // Settings
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings');
    Route::put('/settings', [SettingsController::class, 'update'])->name('settings.update');

    Route::get('/filemanager', [FileManagerController::class, 'index'])->name('filemanager');
    Route::get('/filemanager/browse/{folder}', [FileManagerController::class, 'browse'])->name('filemanager.browse');
    Route::get('/filemanager/edit/{folder}/{file}', [FileManagerController::class, 'edit'])->name('filemanager.edit')->where('file', '.*');
    Route::post('/filemanager/edit/{folder}/{file}', [FileManagerController::class, 'update'])->name('filemanager.update')->where('file', '.*');
    Route::delete('/filemanager/file/{folder}/{file}', [FileManagerController::class, 'deleteFile'])->name('filemanager.deletefile')->where('file', '.*');
    Route::delete('/filemanager/{folder}', [FileManagerController::class, 'delete'])->name('filemanager.delete');
});