<!-- Desktop Sidebar -->
<aside style="width: 16rem; flex-shrink: 0; display: flex;" class="sidebar">
    <div style="display: flex; flex-direction: column; height: 100%;">
        <!-- Logo -->
        <div
            style="display: flex; align-items: center; justify-content: center; height: 4rem; border-bottom: 1px solid var(--border-subtle);">
            <span class="text-primary"
                style="font-size: 1.25rem; font-weight: 700; letter-spacing: -0.02em;"><?php echo e(getSiteName()); ?></span>
        </div>

        <!-- Navigation -->
        <nav style="flex: 1; padding: 1.5rem 0.75rem; overflow-y: auto;">
            <a href="<?php echo e(route('dashboard')); ?>" class="nav-item <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                <i class="bi bi-house-fill" style="font-size: 1.125rem;"></i>
                <span>Dashboard</span>
            </a>

            <a href="<?php echo e(route('bots.index')); ?>" class="nav-item <?php echo e(request()->routeIs('bots.index') ? 'active' : ''); ?>">
                <i class="bi bi-list-ul" style="font-size: 1.125rem;"></i>
                <span>List Bot</span>
            </a>

            <a href="<?php echo e(route('bots.create')); ?>"
                class="nav-item <?php echo e(request()->routeIs('bots.create') ? 'active' : ''); ?>">
                <i class="bi bi-plus-circle-fill" style="font-size: 1.125rem;"></i>
                <span>Create Bot</span>
            </a>

            <a href="<?php echo e(route('filemanager')); ?>"
                class="nav-item <?php echo e(request()->routeIs('filemanager') ? 'active' : ''); ?>">
                <i class="bi bi-folder-fill" style="font-size: 1.125rem;"></i>
                <span>File Manager</span>
            </a>

            <a href="<?php echo e(route('settings')); ?>" class="nav-item <?php echo e(request()->routeIs('settings') ? 'active' : ''); ?>">
                <i class="bi bi-gear-fill" style="font-size: 1.125rem;"></i>
                <span>Settings</span>
            </a>
        </nav>

        <!-- User Info & Logout -->
        <div style="padding: 1rem 0.75rem; border-top: 1px solid var(--border-subtle);">
            <div class="user-card">
                <div style="display: flex; align-items: center; gap: 0.75rem;">
                    <div class="user-avatar">
                        <span
                            style="color: white; font-weight: 600; font-size: 0.875rem;"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></span>
                    </div>
                    <div style="flex: 1; min-width: 0;">
                        <p class="text-primary"
                            style="font-size: 0.875rem; font-weight: 600; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                            <?php echo e(Auth::user()->name); ?></p>
                        <p class="text-secondary"
                            style="font-size: 0.75rem; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                            <?php echo e(Auth::user()->email); ?></p>
                    </div>
                </div>
            </div>
            <form action="<?php echo e(route('logout')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-danger" style="width: 100%; margin-top: 0.75rem;">
                    <i class="bi bi-box-arrow-right"></i>
                    <span>Logout</span>
                </button>
            </form>
            <div class="text-tertiary" style="margin-top: 0.75rem; text-align: center; font-size: 0.75rem;">
                Python <span class="text-secondary" style="font-weight: 600;"><?php echo e(getPythonVersion()); ?></span>
            </div>
        </div>
    </div>
</aside>

<!-- Mobile Sidebar -->
<div id="mobile-sidebar-overlay" class="sidebar-overlay">
    <aside id="mobile-sidebar" class="sidebar sidebar-mobile">
        <div style="display: flex; flex-direction: column; height: 100%;">
            <div
                style="display: flex; align-items: center; justify-content: space-between; height: 4rem; border-bottom: 1px solid var(--border-subtle); padding: 0 1rem;">
                <span class="text-primary"
                    style="font-size: 1.25rem; font-weight: 700; letter-spacing: -0.02em;"><?php echo e(getSiteName()); ?></span>
                <button id="close-mobile-sidebar" class="btn-icon">
                    <i class="bi bi-x-lg text-secondary"></i>
                </button>
            </div>

            <nav style="flex: 1; padding: 1.5rem 0.75rem; overflow-y: auto;">
                <a href="<?php echo e(route('dashboard')); ?>"
                    class="nav-item <?php echo e(request()->routeIs('dashboard') ? 'active' : ''); ?>">
                    <i class="bi bi-house-fill" style="font-size: 1.125rem;"></i>
                    <span>Dashboard</span>
                </a>
                <a href="<?php echo e(route('bots.index')); ?>"
                    class="nav-item <?php echo e(request()->routeIs('bots.index') ? 'active' : ''); ?>">
                    <i class="bi bi-list-ul" style="font-size: 1.125rem;"></i>
                    <span>List Bot</span>
                </a>
                <a href="<?php echo e(route('bots.create')); ?>"
                    class="nav-item <?php echo e(request()->routeIs('bots.create') ? 'active' : ''); ?>">
                    <i class="bi bi-plus-circle-fill" style="font-size: 1.125rem;"></i>
                    <span>Create Bot</span>
                </a>
                <a href="<?php echo e(route('filemanager')); ?>"
                    class="nav-item <?php echo e(request()->routeIs('filemanager') ? 'active' : ''); ?>">
                    <i class="bi bi-folder-fill" style="font-size: 1.125rem;"></i>
                    <span>File Manager</span>
                </a>
                <a href="<?php echo e(route('settings')); ?>" class="nav-item <?php echo e(request()->routeIs('settings') ? 'active' : ''); ?>">
                    <i class="bi bi-gear-fill" style="font-size: 1.125rem;"></i>
                    <span>Settings</span>
                </a>
            </nav>

            <div style="padding: 1rem 0.75rem; border-top: 1px solid var(--border-subtle);">
                <div class="user-card">
                    <div style="display: flex; align-items: center; gap: 0.75rem;">
                        <div class="user-avatar">
                            <span
                                style="color: white; font-weight: 600; font-size: 0.875rem;"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></span>
                        </div>
                        <div style="flex: 1; min-width: 0;">
                            <p class="text-primary"
                                style="font-size: 0.875rem; font-weight: 600; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                <?php echo e(Auth::user()->name); ?></p>
                            <p class="text-secondary"
                                style="font-size: 0.75rem; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                <?php echo e(Auth::user()->email); ?></p>
                        </div>
                    </div>
                </div>
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger" style="width: 100%; margin-top: 0.75rem;">
                        <i class="bi bi-box-arrow-right"></i>
                        <span>Logout</span>
                    </button>
                </form>
            </div>
        </div>
    </aside>
</div><?php /**PATH C:\xampp\htdocs\pyrunner\resources\views/layouts/sidebar.blade.php ENDPATH**/ ?>