<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Login - <?php echo e(getSiteName()); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicon.ico')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet">

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: #0a0a0f;
            color: #ffffff;
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
        }

        /* Particle Background with Meteors */
        .particle-bg {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
            overflow: hidden;
            background: radial-gradient(ellipse at top, #0f0f1a 0%, #0a0a0f 100%);
        }

        /* Ambient glow orbs */
        .particle-bg::before {
            content: '';
            position: absolute;
            top: -10%;
            left: 20%;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(14, 165, 233, 0.15) 0%, transparent 70%);
            border-radius: 50%;
            filter: blur(60px);
            animation: float 25s ease-in-out infinite;
        }

        .particle-bg::after {
            content: '';
            position: absolute;
            bottom: -10%;
            right: 15%;
            width: 600px;
            height: 600px;
            background: radial-gradient(circle, rgba(139, 92, 246, 0.12) 0%, transparent 70%);
            border-radius: 50%;
            filter: blur(80px);
            animation: float 30s ease-in-out infinite reverse;
        }

        @keyframes float {

            0%,
            100% {
                transform: translate(0, 0) scale(1);
                opacity: 0.15;
            }

            50% {
                transform: translate(30px, -30px) scale(1.1);
                opacity: 0.2;
            }
        }

        /* Meteor effect */
        .meteor {
            position: absolute;
            width: 2px;
            height: 2px;
            background: #fff;
            border-radius: 50%;
            box-shadow: 0 0 10px 2px rgba(14, 165, 233, 0.8),
                0 0 20px 4px rgba(14, 165, 233, 0.4);
            animation: meteor-fall linear infinite;
            opacity: 0;
        }

        .meteor::before {
            content: '';
            position: absolute;
            top: 50%;
            right: 0;
            width: 80px;
            height: 1px;
            background: linear-gradient(90deg,
                    rgba(14, 165, 233, 0) 0%,
                    rgba(14, 165, 233, 0.8) 50%,
                    rgba(255, 255, 255, 0.9) 100%);
            transform: translateY(-50%);
        }

        @keyframes meteor-fall {
            0% {
                opacity: 0;
                transform: translate(0, 0) rotate(-45deg);
            }

            10% {
                opacity: 1;
            }

            90% {
                opacity: 1;
            }

            100% {
                opacity: 0;
                transform: translate(-500px, 500px) rotate(-45deg);
            }
        }

        .meteor:nth-child(1) {
            top: 5%;
            left: 10%;
            animation-duration: 3s;
            animation-delay: 0s;
        }

        .meteor:nth-child(2) {
            top: 15%;
            left: 40%;
            animation-duration: 3.5s;
            animation-delay: 1.5s;
        }

        .meteor:nth-child(3) {
            top: 25%;
            left: 70%;
            animation-duration: 2.8s;
            animation-delay: 3s;
        }

        .meteor:nth-child(4) {
            top: 10%;
            left: 85%;
            animation-duration: 3.2s;
            animation-delay: 4.5s;
        }

        .meteor:nth-child(5) {
            top: 30%;
            left: 25%;
            animation-duration: 3.8s;
            animation-delay: 2s;
        }

        .meteor:nth-child(6) {
            top: 20%;
            left: 55%;
            animation-duration: 2.5s;
            animation-delay: 5.5s;
        }

        /* Main container */
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: flex-start;
            justify-content: center;
            padding: 2.5rem 1rem 3rem;
            position: relative;
            z-index: 10;
        }

        .login-wrapper {
            max-width: 440px;
            width: 100%;
        }

        /* Header */
        .login-header {
            text-align: center;
            margin-bottom: 2.5rem;
        }

        .site-logo {
            max-width: 280px;
            height: auto;
            margin: 0 auto 1.5rem;
            display: block;
            filter: drop-shadow(0 0 25px rgba(14, 165, 233, 0.4));
            transition: all 0.3s ease;
        }

        .site-logo:hover {
            filter: drop-shadow(0 0 35px rgba(14, 165, 233, 0.6));
            transform: scale(1.05);
        }

        .site-subtitle {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.5);
            font-weight: 400;
            letter-spacing: 0.05em;
            margin-top: 1.2rem;
        }

        /* Login card */
        .login-card {
            background: rgba(255, 255, 255, 0.08);
            backdrop-filter: blur(50px) saturate(200%);
            -webkit-backdrop-filter: blur(50px) saturate(200%);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 1.5rem;
            padding: 2.5rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3),
                0 0 80px rgba(14, 165, 233, 0.15),
                inset 0 1px 0 rgba(255, 255, 255, 0.25),
                inset 0 -1px 0 rgba(255, 255, 255, 0.1);
            position: relative;
        }

        .login-card::before {
            content: '';
            position: absolute;
            inset: 0;
            border-radius: 1.5rem;
            padding: 1px;
            background: linear-gradient(135deg,
                    rgba(255, 255, 255, 0.4) 0%,
                    rgba(255, 255, 255, 0.1) 50%,
                    rgba(14, 165, 233, 0.2) 100%);
            -webkit-mask: linear-gradient(#fff 0 0) content-box,
                linear-gradient(#fff 0 0);
            mask: linear-gradient(#fff 0 0) content-box,
                linear-gradient(#fff 0 0);
            -webkit-mask-composite: xor;
            mask-composite: exclude;
            pointer-events: none;
        }

        /* Error message */
        .error-box {
            background: rgba(239, 68, 68, 0.1);
            border: 1px solid rgba(239, 68, 68, 0.3);
            color: #fca5a5;
            padding: 1rem 1.25rem;
            border-radius: 0.875rem;
            margin-bottom: 1.75rem;
            box-shadow: 0 0 20px rgba(239, 68, 68, 0.15);
        }

        .error-title {
            font-weight: 600;
            margin-bottom: 0.5rem;
            font-size: 0.95rem;
        }

        .error-list {
            list-style: disc;
            padding-left: 1.25rem;
            font-size: 0.875rem;
        }

        .error-list li {
            margin-bottom: 0.25rem;
        }

        /* Form */
        .login-form {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
        }

        .form-group {
            display: flex;
            flex-direction: column;
        }

        .form-label {
            font-size: 0.875rem;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.85);
            margin-bottom: 0.625rem;
            letter-spacing: 0.02em;
        }

        .form-input {
            width: 100%;
            padding: 0.875rem 1.125rem;
            background: rgba(255, 255, 255, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 0.75rem;
            color: #ffffff;
            font-size: 0.95rem;
            font-family: inherit;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            outline: none;
            backdrop-filter: blur(10px);
        }

        .form-input::placeholder {
            color: rgba(255, 255, 255, 0.3);
        }

        .form-input:focus {
            background: rgba(255, 255, 255, 0.12);
            border-color: rgba(14, 165, 233, 0.6);
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.15),
                0 0 20px rgba(14, 165, 233, 0.25),
                inset 0 1px 0 rgba(255, 255, 255, 0.15);
        }

        .form-input:hover:not(:focus) {
            border-color: rgba(255, 255, 255, 0.25);
            background: rgba(255, 255, 255, 0.1);
        }

        /* Remember me */
        .remember-row {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .remember-checkbox {
            width: 1.125rem;
            height: 1.125rem;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 0.375rem;
            cursor: pointer;
            accent-color: #0ea5e9;
            transition: all 0.2s ease;
        }

        .remember-checkbox:checked {
            background: #0ea5e9;
            border-color: #0ea5e9;
            box-shadow: 0 0 10px rgba(14, 165, 233, 0.4);
        }

        .remember-label {
            font-size: 0.875rem;
            color: rgba(255, 255, 255, 0.6);
            cursor: pointer;
            user-select: none;
        }

        /* Submit button */
        .submit-btn {
            width: 100%;
            padding: 0.95rem 1.5rem;
            background: linear-gradient(135deg, #0ea5e9 0%, #0284c7 100%);
            border: 1px solid rgba(14, 165, 233, 0.3);
            border-radius: 0.875rem;
            color: #ffffff;
            font-size: 0.95rem;
            font-weight: 700;
            letter-spacing: 0.02em;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 4px 16px rgba(14, 165, 233, 0.3),
                0 0 30px rgba(14, 165, 233, 0.2),
                inset 0 1px 0 rgba(255, 255, 255, 0.2);
            position: relative;
            overflow: hidden;
        }

        .submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg,
                    transparent,
                    rgba(255, 255, 255, 0.2),
                    transparent);
            transition: left 0.5s ease;
        }

        .submit-btn:hover::before {
            left: 100%;
        }

        .submit-btn:hover {
            background: linear-gradient(135deg, #38bdf8 0%, #0ea5e9 100%);
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(14, 165, 233, 0.4),
                0 0 40px rgba(14, 165, 233, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.3);
        }

        .submit-btn:active {
            transform: translateY(0);
        }

        /* Responsive */
        @media (max-width: 640px) {
            .login-container {
                padding: 2rem 1rem;
            }

            .site-title {
                font-size: 2rem;
            }

            .login-card {
                padding: 2rem 1.5rem;
            }

            .site-logo {
                max-width: 220px;
            }

            .meteor::before {
                width: 50px;
            }
        }
    </style>
</head>

<body>
    <!-- Particle Background -->
    <div class="particle-bg">
        <div class="meteor"></div>
        <div class="meteor"></div>
        <div class="meteor"></div>
        <div class="meteor"></div>
        <div class="meteor"></div>
        <div class="meteor"></div>
    </div>

    <!-- Login Container -->
    <div class="login-container">
        <div class="login-wrapper">
            <!-- Header -->
            <div class="login-header">
                <img src="<?php echo e(asset('logo.png')); ?>" alt="Logo" class="site-logo">
                <p class="site-subtitle">Python Bot Manager</p>
            </div>

            <!-- Login Card -->
            <div class="login-card">
                <?php if($errors->any()): ?>
                    <div class="error-box">
                        <p class="error-title">Error!</p>
                        <ul class="error-list">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('login')); ?>" method="POST" class="login-form">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" id="email" name="email" value="<?php echo e(old('email')); ?>" class="form-input"
                            placeholder="admin@pyrunner.com" required autofocus>
                    </div>

                    <div class="form-group">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" id="password" name="password" class="form-input" placeholder="••••••••"
                            required>
                    </div>

                    <div class="remember-row">
                        <input type="checkbox" id="remember" name="remember" class="remember-checkbox">
                        <label for="remember" class="remember-label">
                            Remember me
                        </label>
                    </div>

                    <button type="submit" class="submit-btn">
                        Login
                    </button>
                </form>
            </div>
        </div>
    </div>
</body>

</html><?php /**PATH C:\xampp\htdocs\pyrunner\resources\views/auth/login.blade.php ENDPATH**/ ?>