

<?php $__env->startSection('title', 'List Bot - PyRunner 2.0.1'); ?>
<?php $__env->startSection('page-title', 'List Bot'); ?>
<?php $__env->startSection('page-subtitle', 'Kelola semua bot yang telah dibuat'); ?>

<?php $__env->startSection('content'); ?>
    <?php if(session('success')): ?>
        <div class="bg-green-500/10 border border-green-500/20 text-green-400 p-4 mb-6 rounded-lg alert-enter">
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                        clip-rule="evenodd" />
                </svg>
                <p class="font-medium"><?php echo e(session('success')); ?></p>
            </div>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="bg-red-500/10 border border-red-500/20 text-red-400 p-4 mb-6 rounded-lg alert-enter">
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                        clip-rule="evenodd" />
                </svg>
                <p class="font-medium"><?php echo e(session('error')); ?></p>
            </div>
        </div>
    <?php endif; ?>

    <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-zinc-800">
                <thead class="bg-zinc-900/50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">No</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Nama Bot
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Command
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Status
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Dibuat
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-zinc-500 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-zinc-800">
                    <?php $__empty_1 = true; $__currentLoopData = $bots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-zinc-800/50 transition-colors duration-150">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-zinc-400"><?php echo e($key + 1); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-zinc-200"><?php echo e($bot->name); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <code
                                    class="text-xs bg-zinc-800 px-2 py-1 rounded text-zinc-400 border border-zinc-700"><?php echo e($bot->command); ?></code>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php if($bot->status === 'running'): ?>
                                    <span
                                        class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-green-500/10 text-green-400 border border-green-500/20">
                                        <span class="w-1.5 h-1.5 bg-green-400 rounded-full mr-1.5 animate-pulse"></span>
                                        Running
                                    </span>
                                <?php else: ?>
                                    <span
                                        class="inline-flex items-center px-2.5 py-1 rounded-md text-xs font-medium bg-zinc-800 text-zinc-400 border border-zinc-700">
                                        <span class="w-1.5 h-1.5 bg-zinc-500 rounded-full mr-1.5"></span>
                                        Stopped
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-zinc-500">
                                <?php echo e($bot->created_at->format('d/m/Y H:i')); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <div class="flex items-center gap-2">
                                    <?php if($bot->status === 'stopped'): ?>
                                        <button type="submit" form="start-<?php echo e($bot->id); ?>" class="btn-start">
                                            <i class="bi bi-play-fill"></i>
                                            <span>Start</span>
                                        </button>
                                        <form id="start-<?php echo e($bot->id); ?>" action="<?php echo e(route('bots.start', $bot)); ?>" method="POST"
                                            class="hidden">
                                            <?php echo csrf_field(); ?>
                                        </form>
                                    <?php else: ?>
                                        <button type="submit" form="stop-<?php echo e($bot->id); ?>" class="btn-stop">
                                            <i class="bi bi-stop-fill"></i>
                                            <span>Stop</span>
                                        </button>
                                        <form id="stop-<?php echo e($bot->id); ?>" action="<?php echo e(route('bots.stop', $bot)); ?>" method="POST"
                                            class="hidden">
                                            <?php echo csrf_field(); ?>
                                        </form>

                                        <button type="submit" form="restart-<?php echo e($bot->id); ?>" class="btn-restart">
                                            <i class="bi bi-arrow-clockwise"></i>
                                            <span>Restart</span>
                                        </button>
                                        <form id="restart-<?php echo e($bot->id); ?>" action="<?php echo e(route('bots.restart', $bot)); ?>" method="POST"
                                            class="hidden">
                                            <?php echo csrf_field(); ?>
                                        </form>
                                    <?php endif; ?>

                                    <a href="<?php echo e(route('bots.logs', $bot)); ?>" class="btn-logs">
                                        <i class="bi bi-file-text"></i>
                                        <span>Logs</span>
                                    </a>

                                    <button type="submit" form="delete-<?php echo e($bot->id); ?>" class="btn-delete"
                                        onclick="return confirm('Yakin ingin menghapus bot ini?')">
                                        <i class="bi bi-trash-fill"></i>
                                        <span>Hapus</span>
                                    </button>
                                    <form id="delete-<?php echo e($bot->id); ?>" action="<?php echo e(route('bots.destroy', $bot)); ?>" method="POST"
                                        class="hidden">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center">
                                    <svg class="w-16 h-16 text-zinc-700 mb-4" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4" />
                                    </svg>
                                    <p class="text-zinc-400 text-lg font-medium mb-1">Belum ada bot</p>
                                    <p class="text-zinc-600 text-sm mb-4">Silakan tambah bot baru untuk memulai</p>
                                    <a href="<?php echo e(route('bots.create')); ?>"
                                        class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2.5 rounded-lg transition-all duration-200 inline-flex items-center font-medium">
                                        <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd"
                                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                                clip-rule="evenodd" />
                                        </svg>
                                        Tambah Bot
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pyrunner\resources\views/bots/index.blade.php ENDPATH**/ ?>