<?php $__env->startSection('title', 'Dashboard - PyRunner 2.0.1'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>
<?php $__env->startSection('page-subtitle', 'Overview sistem bot management'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Stats Cards -->
    <div
        style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin-bottom: 2rem;">
        <!-- Total Bots -->
        <div class="card fade-in-up">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <div style="flex: 1;">
                    <p class="text-secondary" style="font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Total
                        Bots</p>
                    <p class="text-primary" style="font-size: 1.875rem; font-weight: 700;"><?php echo e($totalBots); ?></p>
                </div>
                <div class="icon-container">
                    <i class="bi bi-list-ul text-accent" style="font-size: 1.5rem;"></i>
                </div>
            </div>
        </div>

        <!-- Running Bots -->
        <div class="card fade-in-up" style="animation-delay: 0.1s">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <div style="flex: 1;">
                    <p class="text-secondary" style="font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Running
                    </p>
                    <p class="text-success" style="font-size: 1.875rem; font-weight: 700;"><?php echo e($runningBots); ?></p>
                </div>
                <div class="icon-container"
                    style="background: var(--success-subtle); border-color: rgba(52, 199, 89, 0.2);">
                    <i class="bi bi-play-circle-fill pulse text-success" style="font-size: 1.5rem;"></i>
                </div>
            </div>
        </div>

        <!-- Stopped Bots -->
        <div class="card fade-in-up" style="animation-delay: 0.2s">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <div style="flex: 1;">
                    <p class="text-secondary" style="font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Stopped
                    </p>
                    <p class="text-secondary" style="font-size: 1.875rem; font-weight: 700;"><?php echo e($stoppedBots); ?></p>
                </div>
                <div class="icon-container"
                    style="background: var(--neutral-subtle); border-color: rgba(142, 142, 147, 0.2);">
                    <i class="bi bi-stop-circle-fill text-neutral" style="font-size: 1.5rem;"></i>
                </div>
            </div>
        </div>

        <!-- Python Version -->
        <div class="card fade-in-up" style="animation-delay: 0.3s">
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <div style="flex: 1; min-width: 0;">
                    <p class="text-secondary" style="font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Python
                    </p>
                    <p class="text-accent"
                        style="font-size: 1.5rem; font-weight: 700; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                        <?php echo e(getPythonVersion()); ?></p>
                </div>
                <div class="icon-container">
                    <i class="bi bi-code-slash text-accent" style="font-size: 1.5rem;"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Bots Table -->
    <div class="table-container fade-in-up" style="animation-delay: 0.4s">
        <div style="padding: 1rem 1.5rem; border-bottom: 1px solid var(--border-subtle);">
            <h2 class="text-primary"
                style="font-size: 1.125rem; font-weight: 600; display: flex; align-items: center; gap: 0.5rem;">
                <i class="bi bi-clock-history text-accent"></i>
                Recent Bots
            </h2>
        </div>

        <!-- Mobile: Card View -->
        <div class="table-mobile">
            <?php $__empty_1 = true; $__currentLoopData = $recentBots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div style="padding: 1rem; border-bottom: 1px solid var(--border-subtle);">
                    <div style="display: flex; align-items: flex-start; justify-content: space-between; margin-bottom: 0.5rem;">
                        <div style="flex: 1; min-width: 0;">
                            <p class="text-primary"
                                style="font-weight: 600; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; display: flex; align-items: center; gap: 0.5rem;">
                                <i class="bi bi-robot text-accent"></i>
                                <?php echo e($bot->name); ?>

                            </p>
                            <code class="text-secondary"
                                style="font-size: 0.75rem; display: block; margin-top: 0.25rem; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;"><?php echo e($bot->command); ?></code>
                        </div>
                        <div style="margin-left: 0.5rem; flex-shrink: 0;">
                            <?php if($bot->status === 'running'): ?>
                                <span class="status-badge status-running">
                                    <i class="bi bi-circle-fill pulse" style="font-size: 0.625rem;"></i>
                                    Running
                                </span>
                            <?php else: ?>
                                <span class="status-badge status-stopped">
                                    <i class="bi bi-circle-fill" style="font-size: 0.625rem;"></i>
                                    Stopped
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <p class="text-tertiary" style="font-size: 0.75rem; display: flex; align-items: center; gap: 0.25rem;">
                        <i class="bi bi-clock"></i>
                        <?php echo e($bot->created_at->diffForHumans()); ?>

                    </p>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div style="padding: 3rem 1.5rem; text-align: center;">
                    <i class="bi bi-inbox text-tertiary"
                        style="font-size: 3rem; display: block; margin-bottom: 0.75rem; opacity: 0.5;"></i>
                    <p class="text-secondary" style="font-size: 0.875rem;">Belum ada bot</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Desktop: Table View -->
        <div class="table-desktop" style="overflow-x: auto;">
            <table style="width: 100%;">
                <thead style="background: rgba(255, 255, 255, 0.02);">
                    <tr>
                        <th class="text-tertiary"
                            style="padding: 0.75rem 1.5rem; text-align: left; font-size: 0.75rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                            Nama Bot</th>
                        <th class="text-tertiary"
                            style="padding: 0.75rem 1.5rem; text-align: left; font-size: 0.75rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                            Command</th>
                        <th class="text-tertiary"
                            style="padding: 0.75rem 1.5rem; text-align: left; font-size: 0.75rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                            Status</th>
                        <th class="text-tertiary"
                            style="padding: 0.75rem 1.5rem; text-align: left; font-size: 0.75rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                            Dibuat</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $recentBots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="padding: 1rem 1.5rem;">
                                <div style="display: flex; align-items: center; gap: 0.5rem;">
                                    <i class="bi bi-robot text-accent"></i>
                                    <span class="text-primary" style="font-weight: 500;"><?php echo e($bot->name); ?></span>
                                </div>
                            </td>
                            <td style="padding: 1rem 1.5rem;">
                                <code class="text-secondary"
                                    style="font-size: 0.75rem; background: var(--bg-elevated); padding: 0.375rem 0.625rem; border-radius: var(--radius-sm); border: 1px solid var(--border-subtle);"><?php echo e($bot->command); ?></code>
                            </td>
                            <td style="padding: 1rem 1.5rem;">
                                <?php if($bot->status === 'running'): ?>
                                    <span class="status-badge status-running">
                                        <i class="bi bi-circle-fill pulse" style="font-size: 0.625rem;"></i>
                                        Running
                                    </span>
                                <?php else: ?>
                                    <span class="status-badge status-stopped">
                                        <i class="bi bi-circle-fill" style="font-size: 0.625rem;"></i>
                                        Stopped
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td class="text-secondary" style="padding: 1rem 1.5rem; font-size: 0.875rem;">
                                <div style="display: flex; align-items: center; gap: 0.375rem;">
                                    <i class="bi bi-clock"></i>
                                    <?php echo e($bot->created_at->diffForHumans()); ?>

                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" style="padding: 4rem 1.5rem; text-align: center;">
                                <i class="bi bi-inbox text-tertiary"
                                    style="font-size: 4rem; display: block; margin-bottom: 1rem; opacity: 0.3;"></i>
                                <p class="text-secondary">Belum ada bot</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pyrunner\resources\views/dashboard.blade.php ENDPATH**/ ?>