

<?php $__env->startSection('title', 'Bot Logs - PyRunner 2.0.1'); ?>
<?php $__env->startSection('page-title', 'Bot Logs'); ?>
<?php $__env->startSection('page-subtitle', $bot->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6 flex items-center justify-between">
        <a href="<?php echo e(route('bots.index')); ?>"
            class="inline-flex items-center text-zinc-400 hover:text-zinc-200 transition-colors duration-200">
            <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd"
                    d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z"
                    clip-rule="evenodd" />
            </svg>
            Kembali ke List Bot
        </a>

        <form action="<?php echo e(route('bots.logs.clear', $bot)); ?>" method="POST"
            onsubmit="return confirm('Yakin ingin menghapus semua log?')">
            <?php echo csrf_field(); ?>
            <button type="submit"
                class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg transition-all duration-200 inline-flex items-center font-medium">
                <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z"
                        clip-rule="evenodd" />
                </svg>
                Clear Logs
            </button>
        </form>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-500/10 border border-green-500/20 text-green-400 p-4 mb-6 rounded-lg alert-enter">
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                        clip-rule="evenodd" />
                </svg>
                <p class="font-medium"><?php echo e(session('success')); ?></p>
            </div>
        </div>
    <?php endif; ?>

    <div class="bg-zinc-900 border border-zinc-800 rounded-xl overflow-hidden">
        <div class="px-6 py-4 border-b border-zinc-800">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 rounded-lg bg-zinc-700 flex items-center justify-center">
                        <svg class="w-6 h-6 text-zinc-300" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z" />
                            <path fill-rule="evenodd"
                                d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z"
                                clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-zinc-100"><?php echo e($bot->name); ?></h3>
                        <p class="text-sm text-zinc-500">Output Logs</p>
                    </div>
                </div>
                <div>
                    <?php if($bot->status === 'running'): ?>
                        <span
                            class="inline-flex items-center px-3 py-1.5 rounded-md text-sm font-medium bg-green-500/10 text-green-400 border border-green-500/20">
                            <span class="w-2 h-2 bg-green-400 rounded-full mr-2 animate-pulse"></span>
                            Running
                        </span>
                    <?php else: ?>
                        <span
                            class="inline-flex items-center px-3 py-1.5 rounded-md text-sm font-medium bg-zinc-800 text-zinc-400 border border-zinc-700">
                            <span class="w-2 h-2 bg-zinc-500 rounded-full mr-2"></span>
                            Stopped
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="p-6">
            <div class="bg-zinc-950 border border-zinc-800 rounded-lg p-4 overflow-auto max-h-[600px]">
                <pre class="text-sm text-zinc-300 font-mono whitespace-pre-wrap"><?php echo e($logs); ?></pre>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\pyrunner\resources\views/bots/logs.blade.php ENDPATH**/ ?>